<?php
use App\Libraries\Common;
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
    <!--<![endif]-->
    <!-- BEGIN HEAD -->

    <head>
        <meta charset="utf-8" />
        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="{{ config('app.name', 'Laravel') }}" name="description" />
        <meta content="" name="author" />
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
        <link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css" />
    <!-- END HEAD -->
    <body class="pdf">
<table class="">
    <tbody>
    <tr>
        <td colspan="5" rowspan="10" class="pdftd va-top">
            <p style="font-size: 34px; line-height: 1"><b class="bcollor"> PLEASE READ CAREFULLY, CHECK ONE OF THE STATEMENTS BELOW, AND SIGN: </b></p>
            <br/>
            <p style="font-size: 32px; line-height: 1">I UNDERSTAND THAT, UNDER STATE LAW, I AM ENTITLED TO A WRITTEN ESTIMATE IF MY FINAL BILL WILL EXCEED $100.</p><br/>
            <p style="font-size: 32px; line-height: 1"><span class="underlineb">{{$invoice->written_estimate == 'y' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;'}}</span>I REQUEST A WRITTEN ESTIMATE.</p><br/>
            <p style="font-size: 32px; line-height: 1"><span class="underlineb">{{$invoice->written_estimate == 'n' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;'}}</span>I DO NOT REQUEST A WRITTEN ESTIMATE.</p><br/>
            <p style="font-size: 32px; line-height: 1"><span class="underlineb">{{$invoice->written_estimate == 'exceed' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;'}}</span> I DO NOT REQUEST A WRITTEN ESTIMATE AS LONG AS THE REPAIR COSTS DO NOT EXCEED <span class="underlineb">${{$invoice->written_amount ? $invoice->written_amount : '0.00'}}</span>. THE SHOP MAY NOT EXCEED THIS AMOUNT WITHOUT MY WRITTEN OR ORAL APPROVAL.</p>
            <br/>
            <table>
                <tr>
                    <td style="vertical-align: bottom; text-align: center"><p style="font-size: 32px; line-height: 1">SIGNED:</p></td>
                    <td style="vertical-align: bottom; text-align: center">
                        <?php if(!empty($img)) :?>
                        <img src="{{$img}}" width="250px" height="auto" style="margin: 0;object-fit: contain"/>
                        <?php else :?>
                        <br/><br/><br/><br/>
                        <?php endif;?><p>&nbsp;&nbsp;_________________________________________&nbsp;&nbsp;</p>
                    </td>
                    <td style="vertical-align: bottom; text-align: center"><p style="font-size: 32px; line-height: 1">DATE: {{date("m/d/Y")}}</p></td>
                </tr>
            </table>
            <br/>
        </td>
        <td colspan="6" rowspan="4" class="pdftd text-center">
            <p style="font-size: 60px; line-height: 1"><b class="bcollor">{{$settings['company_name']}}</b></p>
            <p style="font-size: 32px; line-height: 1">GENERAL MECHANIC</p>
            <p style="font-size: 32px; line-height: 1">{{$settings['company_adress']}}</p>
            <p style="font-size: 32px; line-height: 1">Phs: {{$settings['company_phone']}}</p>
            <p style="font-size: 34px; line-height: 1"> <b class="bcollor">MVR: {{$settings['mvr']}}</b>   <b class="bcollor">{{$settings['licence']}}</b></p>
        </td>
        <td colspan="5" class="pdftd text-center">
            <?php if($invoice->warranty_type == 'month') :?><p style="font-size: 32px; line-height: 1"> <span class="underlineb">{{$invoice->warranty_amount}}</span> month/mile warranty on all parts.</p><?php endif;?>
            <?php if($invoice->warranty_type == 'mile') :?><p style="font-size: 32px; line-height: 1"> month/ <span class="underlineb">{{$invoice->warranty_amount}}</span> mile warranty on all parts.</p><?php endif;?>
        </td>
    </tr>
    <tr class="text-center">
        <td colspan="5" class="text-center ftmed pdftd"><p style="font-size: 32px; line-height: 1"> Intended Payment Method:</p></td>
   </tr>
    <tr class="text-center">
        <td id="pay_cell" colspan="5" class="text-center pdftd"><p style="font-size: 32px; line-height: 1">{{$invoice->payment_method}}</p></td>
    </tr>
    <tr class="text-center">  
        <td colspan="5" class="pdftd"><p style="font-size: 32px; line-height: 1">Date:  <b class="bcollor">{{$invoice->pdf_date}}</b>&nbsp;&nbsp; Time:  <b class="bcollor">{{$invoice->pdf_time}}</b></p></td>             
     </tr>
    <tr>   
        <td colspan="6" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Name:</b> {{$invoice->client->name}}</p></td>            
        <td colspan="5" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Proposed Completion Date:</b></p></td>
    </tr>
    <tr>
        <td colspan="6" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Address:</b> {{$invoice->client->address}}</p></td>
        <td colspan="5" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Home Ph:</b> {{$invoice->client->home_ph}}</p></td>               
    </tr>
    <tr>
        <td colspan="2" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">City:</b> {{$invoice->client->city}}</p></td>
        <td colspan="2" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">State:</b>  {{$invoice->client->state}}</p></td>
        <td colspan="2" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Zip:</b> {{$invoice->client->zip}}</p></td>
        <td colspan="5" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Work Ph:</b> {{$invoice->client->work_ph}}</p></td>                   
    </tr>
    <tr>
        <td colspan="6" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Other Authorized Person:</b> {{$invoice->client->person}}</p></td>
        <td colspan="5" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Phone:</b> {{$invoice->client->phone}}</p></td>               
    </tr>
    <tr>
        <td colspan="3" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Year/Make:</b> {{$invoice->vehicle->year_make}}</p></td> 
        <td colspan="3" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Model:</b> {{$invoice->vehicle->model}}</p></td> 
        <td colspan="2" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Tag:</b> {{$invoice->client->tag}}</p></td>
        <td colspan="3" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Miles In:</b> {{$invoice->miles_in}}</p></td>
    </tr>
    <tr>
        <td colspan="8" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">VIN#:</b> {{$invoice->vehicle->number}}</p></td>               
        <td colspan="3" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Miles Out:</b> {{$invoice->miles_out}}</p></td>
    </tr>
    <tr>
        <td colspan="5" class="center ftsmall pdftd"><p style="font-size: 20px; line-height: 1"> *U/Used&nbsp;R:Rebuilt&nbsp;RC/Reconditioned&nbsp;NC/No Chg/Warranty&nbsp;RD/Reduced/ </p></td>
        <td colspan="11" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Save Old Parts:</b> {{$invoice->save_old_parts}} (Core may apply) </p></td>
    </tr>
    <tr>
        <td class="col_qty pdftd" style="width: 3%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Qty</b></p></td>
        <td class="col_part pdftd" style="width: 4%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Part</b></p></td>
        <td class="col_dsc pdftd" style="width: 28%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Description</b></p></td>
        <td class="col_prc pdftd" style="width: 5%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Price</b></p></td>
        <td class="col_prc pdftd" style="width: 5%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Warranty</b></p></td>
        <td colspan="3" rowspan="2" class="pdftd" style="width: 27.5%"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Complaint/Problem:</b></p></td>
        <td colspan="8" rowspan="2" class="pdftd" style="width: 27.5%"><p style="font-size: 32px; line-height: 1">{{$invoice->complaint_problem}}</p></td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 0)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 1)?>
        <td class="pdftd" colspan="3" rowspan="2"><p style="font-size: 32px; line-height: 1">
            <b class="bcollor">Labor charges based on:</b><br>
            {{$invoice->charges_type}} rate
            </p>
        </td>
        <td class="pdftd" colspan="8" rowspan="2"> <p style="font-size: 32px; line-height: 1">
            <b class="bcollor">Estimate/diagnostic fee:</b><br>
            <label id="lb_hourly_at"><?php if($invoice->diagnostic_type == "hourly_at"):?><span class="underlineb">$ <?php echo number_format($invoice->diagnostic_amount,2)?></span><?php endif;?></label> / Or hourly at &nbsp;
            <label id="lb_per_hour"><?php if($invoice->diagnostic_type == "per_hour"):?><span class="underlineb">$ <?php echo number_format($invoice->diagnostic_amount,2)?></span><?php endif;?></label>  Per hour    
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 2)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 3)?>
        <td colspan="11" class="pdftd">
            <p style="font-size: 32px; line-height: 1">A storage fee of $ <span class="underlineb">{{$invoice->storage_fee}}</span> per day may be applied to vehicles which are not claimed within 3 working days </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 4)?>
        <td colspan="6" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Description of Repairs (invoice)</b></p></td>
        <td class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Labor</b></p></td>
        <td class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Time</b></p></td>
        <td colspan="3" class="pdftd"><p style="font-size: 32px; line-height: 1"><b class="bcollor">Charges</b></p></td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 5)?>
        <?php echo Common::repairRow($invoice->repairs, 0)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">PARTS:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($parts, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 6)?>
        <?php echo Common::repairRow($invoice->repairs, 1)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 7)?>
        <?php echo Common::repairRow($invoice->repairs, 2)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">LABOR:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($repairs, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 8)?>
        <?php echo Common::repairRow($invoice->repairs, 3)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 9)?>
        <?php echo Common::repairRow($invoice->repairs, 4)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">SUBLET/OTHER:</b>
            </p>
               <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($invoice->sublet_other, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 10)?>
        <?php echo Common::repairRow($invoice->repairs, 5)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 11)?>
        <?php echo Common::repairRow($invoice->repairs, 6)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">SUPPLIES:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($invoice->shop_supplies, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 12)?>
        <?php echo Common::repairRow($invoice->repairs, 7)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 13)?>
        <?php echo Common::repairRow($invoice->repairs, 8)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">FEES:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($invoice->fees, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 14)?>
        <?php echo Common::repairRow($invoice->repairs, 9)?>
    </tr>
    <tr>
        <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 15)?>
        <?php echo Common::repairRow($invoice->repairs, 10)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">SUB-TOTAL:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($sub_total, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <td colspan="5" rowspan="4" class="pdftd"><p style="font-size: 32px; line-height: 1">
                            Estimate good for 30 days. Not responsible for damage caused by theft, fire or acts of nature. I hereby authorize the above repairs, including sublet work, along with the necessary materials. You and your employees may operate my vehicle for the purpose of testing, inspection and delivery at my risk. If I cancel repairs prior to their completion for any reason, a tear down and reassembly fee of <span class="underlineb">$ {{$invoice->cancel_fee}}</span> will be applied. 
            <table>
                <tr>
                    <td style="vertical-align: bottom; text-align: center"><p style="font-size: 32px; line-height: 1">SIGNED:</p></td>
                    <td style="vertical-align: bottom; text-align: center">
                        <br/><br/><br/><br/>
                        <p>&nbsp;&nbsp;_________________________________________&nbsp;&nbsp;</p>
                    </td>
                    <td style="vertical-align: bottom; text-align: center"><p style="font-size: 32px; line-height: 1">DATE: {{date("m/d/Y")}}</p></td>
                </tr>
            </table>
        </td>
        <?php echo Common::repairRow($invoice->repairs, 11)?>
    </tr>
    <tr>

        <?php echo Common::repairRow($invoice->repairs, 12)?>
        <td class="dh pdftd" colspan="3" rowspan="2"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">TAX:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($tax, 2)}}
            </p>
        </td>
    </tr>
    <tr>
        <?php echo Common::repairRow($invoice->repairs, 13)?>
    </tr>
    <tr>

        <td colspan="8" class="pdftd"><p style="font-size: 32px; line-height: 1">**This charge represents costs and profits to the motor vehicle repair facility for miscellaneus shop supplies or waste disposal. ***FS403.718 mandates a $1.00 fee for each new tire sold in the Sate of Florida. ***FS403.7185 mandates a $1.50 fee for each new or remanufactured battery sold in the State of Florida. </p></td>
        <td class="dh pdftd" colspan="3"><p style="font-size: 34px; line-height: 1">
            <b class="bcollor">TOTAL:</b>
            </p>
            <p class="bcollor" style="font-size: 50px; line-height: 1">
            $ {{number_format($total, 2)}}
            </p>
        </td>
    </tr>
    </tbody>
</table>
    </body>
</html>