<?php
namespace App\Http\Controllers\Api;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Invoice;
use App\InvoiceBill;
use App\InvoicePart;
use App\Client as Client;
use Twilio\Rest\Client as ClientSms;
use App\Vehicle;
use App\Repair;
use App\Bill;
use App\Part;
use App\Setting;
use \App\Deposit;
use App\Libraries\Common;
use App\BillDetail;
use App\Payment;

class InvoicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Invoice::where("invoices.deleted", 0)
                ->when($request->get("status"), function($query) use ($request){
                        return $query->where("status", $request->get("status"));
                    })
                ->when($request->get("invoice_number"), function($query) use ($request){
                        return $query->where("invoice_number", "like", "%".$request->get("invoice_number")."%");
                    })
                ->when($request->get("client"), function($query) use ($request){
                        return $query->join('clients', 'clients.id', '=', 'invoices.client_id')
                                ->where("clients.id", $request->get("client"));
                    })
                ->when($request->get("worker"), function($query) use ($request){
                        return $query->join('workers', 'workers.id', '=', 'invoices.worker_id')
                                ->where("workers.id", $request->get("worker"));
                    })
                ->when($request->get("from"), function($query) use ($request){
                        return $query->where("form_date", ">=", date('Y-m-d H:i:s', strtotime($request->get("from"))));
                    })
                ->when($request->get("to"), function($query) use ($request){
                        return $query->where("form_date", "<=", date('Y-m-d H:i:s', strtotime($request->get("to")." 23:59:59")));
                    })
                ->when($request->get("payment_method"), function($query) use ($request){
                        return $query->where("payment_method",$request->get("payment_method"));
                    })
                ->with(['client','worker', 'vehicle', "bills", 'parts', 'repairs', 'deposits'])
                ->orderBy('invoices.invoice_number','DESC')
                ->select([
                    "invoices.*", 
                    DB::raw("'0' as loading"),
                    DB::raw("'0' as loading_signed_pdf"),
                    ])
                ->paginate($per_page);
        return $data;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $this->validate($request, [
            //"invoice_number" => 'required',
            //"bill_id_old" => 'required',
            //"form_date" => 'required',
            //"client_ab" => 'required',
            "written_estimate" => 'required',
            //"written_amount" => 'required',
            //"cancel_fee" => 'required',
            //"storage_fee" => 'required',
            "diagnostic_type" => 'required',
            //"diagnostic_amount" => 'required',
            "charges_type" => 'required',
            //"charges_amount" => 'required',
            //"sublet_other" => 'required',
            //"shop_supplies" => 'required',
            //"fees" => 'required',
            "save_old_parts" => 'required',
            //"complaint_problem" => 'required',
            "warranty_type" => 'required',
            //"warranty_amount" => 'required',
            //"miles_in" => 'required',
            //"miles_out" => 'required',
            "payment_method" => 'required',
            "repair_type" => 'required',
            //"client_id" => 'required',
            //"vehicle_id" => 'required',
            "worker_id" => 'required',
            //"prov" => 'required',
            //"part_invoices" => 'required',
            "pdf_date" => 'required',
            "pdf_time" => 'required',
        ]);
        if($invoice = Invoice::create($request->all())){
            
            $in = Setting::where("key","inv_counter")->firstOrFail();
            $invoice->invoice_number = $in->value;
            $in->value = $in->value+1;
            $in->save();
            $invoice->save();
            //Setting::where("key","inv_counter")->update(['value' => $invoice->invoice_number + 1]);
            
            $client_data = $request->get('client');
            $client = null;
            if(!isset($client_data['id'])) {
                $client = new Client;
            }
            else {
                $client = Client::find($client_data['id']);
            }
            if(isset($client_data["name"])) $client->name = $client_data["name"];
            if(isset($client_data["address"])) $client->address = $client_data["address"];
            if(isset($client_data["city"])) $client->city = $client_data["city"];
            if(isset($client_data["zip"])) $client->zip = $client_data["zip"];
            if(isset($client_data["person"])) $client->person = $client_data["person"];
            if(isset($client_data["home_ph"])) $client->home_ph = $client_data["home_ph"];
            if(isset($client_data["work_ph"])) $client->work_ph = $client_data["work_ph"];
            if(isset($client_data["phone"])) $client->phone = $client_data["phone"];
            if(isset($client_data["tag"])) $client->tag = $client_data["tag"];
            if(isset($client_data["state"])) $client->state = $client_data["state"];
            if(isset($client_data["email"])) $client->email = $client_data["email"];
            $client->save();
            $invoice->client_id = $client->id;
            
            $vehicle_data = $request->get('vehicle');
            if(!isset($vehicle_data['id'])) {
                $vehicle = new Vehicle;
                if(isset($vehicle_data["year_make"])) $vehicle->year_make = $vehicle_data['year_make'];
                if(isset($vehicle_data["model"])) $vehicle->model = $vehicle_data['model'];
                if(isset($vehicle_data["number"])) $vehicle->number = $vehicle_data['number'];
                $vehicle->save();
                $invoice->vehicle_id = $vehicle->id;
            }
            else $invoice->vehicle_id = $vehicle_data['id'];
            
            $bills = $request->get('bills');
            foreach ($bills as $item) {
                $temp = new InvoiceBill;
                $temp->invoice_id = $invoice->id;
                $temp->bill_id = $item['id'];
                if($temp->save()){
                    Bill::where('id', $item['id'])->update([
                        'in_use' => 'y'
                    ]);
                }   
            }
            $parts = $request->get('parts');
            foreach ($parts as $item){
                $part = new InvoicePart;
                $part->invoice_id = $invoice->id;
                if(isset($item["part_id"])) $part->part_id = $item['part_id'];
                if(isset($item["name"])) $part->name = $item['name'];
                if(isset($item["part_number"])) $part->part_number = $item['part_number'];
                if(isset($item["description"])) $part->description = $item['description'];
                if(isset($item["quantity"])) $part->quantity = $item['quantity'];
                if(isset($item["extend"])) $part->extend = $item['extend'];
                if(isset($item["price"])) $part->price = $item['price'];
                if(isset($item["warranty"])) $part->warranty = $item['warranty'];
                if($part->save()){
                    $p = Part::where('id', $item['part_id'])->first();
                    $p->quantity = $p->quantity - $item['quantity'];
                    $p->save();
                }
            }
            $repairs = $request->get('repairs');
            foreach ($repairs as $item){
                $repair = new Repair;
                $repair->invoice_id = $invoice->id;
                if(isset($item['description'])) $repair->description = $item['description'];
                if(isset($item['labor'])) $repair->labor = $item['labor'];
                if(isset($item['time'])) $repair->time = $item['time'];
                $repair->save();
            }
            
            $deposits = $request->get('deposits');
            foreach ($deposits as $item){
                $deposit = new Deposit;
                $deposit->invoice_id = $invoice->id;
                if(isset($item['description'])) $deposit->description = $item['description'];
                if(isset($item['amount'])) $deposit->amount = $item['amount'];
                $deposit->save();
            }
            
            $invoice->form_date = date("Y-m-d H:i:s"); 
            $invoice->pdf_date = date("m/d/Y"); 
            $invoice->pdf_time = date("h:i a"); 
            if($invoice->status == "paid"){
                $invoice->pay_date = date("Y-m-d H:i:s"); 
            }
            $invoice->save();
            $this->total($invoice->id);
        }
        return;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id){
        $data = Invoice::with(['client','worker', 'vehicle', "bills", 'parts', 'repairs', 'deposits'])
                ->select([
                    "invoices.*", 
                    DB::raw("'0' as loading"),
                    DB::raw("'0' as loading_signed_pdf"),
                    ])
                ->findOrFail($id);
        return $data;
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $this->validate($request, [
            //"invoice_number" => 'required',
            "written_estimate" => 'required',
            "diagnostic_type" => 'required',
            "charges_type" => 'required',
            "save_old_parts" => 'required',
            "warranty_type" => 'required',
            "payment_method" => 'required',
            "repair_type" => 'required',
            "worker_id" => 'required',
            "pdf_date" => 'required',
            "pdf_time" => 'required',
        ]);
        if($request->get('payment_method') != 'cash') {
            $invoice_old = Invoice::findOrFail($id);
        }
        if(Invoice::find($id)->update($request->all())){
            
            $invoice = Invoice::find($id);
            if(file_exists(public_path('pdf/').$invoice->pdf)) @unlink(public_path('pdf/').$invoice->pdf);
            if(file_exists(public_path('pdf/').$invoice->pdf_signed)) @unlink(public_path('pdf/').$invoice->pdf_signed);
            $invoice->pdf = "";
            $invoice->pdf_signed = "";
            
            
            $client_data = $request->get('client');
            $client = "";
            if(!isset($client_data['id'])) {
                $client = new Client;
            }
            else {
                $client = Client::find($client_data['id']);
            }
            if(isset($client_data["name"])) $client->name = $client_data["name"];
            if(isset($client_data["address"])) $client->address = $client_data["address"];
            if(isset($client_data["city"])) $client->city = $client_data["city"];
            if(isset($client_data["zip"])) $client->zip = $client_data["zip"];
            if(isset($client_data["person"])) $client->person = $client_data["person"];
            if(isset($client_data["home_ph"])) $client->home_ph = $client_data["home_ph"];
            if(isset($client_data["work_ph"])) $client->work_ph = $client_data["work_ph"];
            if(isset($client_data["phone"])) $client->phone = $client_data["phone"];
            if(isset($client_data["tag"])) $client->tag = $client_data["tag"];
            if(isset($client_data["state"])) $client->state = $client_data["state"];
            if(isset($client_data["email"])) $client->email = $client_data["email"];
            $client->save();
            $invoice->client_id = $client->id;
            
            /*if($invoice->payment_method != 'cash' && $invoice_old->payment_method == 'cash' && $invoice_old->status != 'paid') {
                $last_month = Payment::orderby('year', 'DESC')->orderby('month', 'DESC')->firstOrFail();
                if(strtotime($invoice->form_date) <= strtotime($last_month->inv_date)) {
                    $invoice->form_date = date("Y-m-d H:i:s"); 
                    $invoice->pdf_date = date("m/d/Y"); 
                    $invoice->pdf_time = date("H:i:s"); 
                }
            }*/
            if($invoice->status == "paid") {
                if(!$invoice->pay_date)
                    $invoice->pay_date = date("Y-m-d H:i:s"); 
            }
            else {
                $invoice->pay_date = null;
            }
            $invoice->pdf_date = date("m/d/Y"); 
            $invoice->pdf_time = date("h:i a"); 
            $invoice->save();
            
            $vehicle_data = $request->get('vehicle');
            if(isset($vehicle_data["year_make"])) $invoice->vehicle->year_make = $vehicle_data['year_make'];
            if(isset($vehicle_data["model"])) $invoice->vehicle->model = $vehicle_data['model'];
            if(isset($vehicle_data["number"])) $invoice->vehicle->number = $vehicle_data['number'];
            $invoice->vehicle->save();
            
            foreach ($invoice->bills as $item) {
                $item->in_use = "n";
                $item->save();
            }
            InvoiceBill::where("invoice_id", $invoice->id)->delete();
            $bills = $request->get('bills');
            foreach ($bills as $item) {
                $temp = new InvoiceBill;
                $temp->invoice_id = $invoice->id;
                $temp->bill_id = $item['id'];
                if($temp->save()){
                    Bill::where('id', $item['id'])->update([
                        'in_use' => 'y'
                    ]);
                }   
            }
            foreach ($invoice->parts as $item) {
                $p = Part::where('id', $item->part_id)->first();
                $p->quantity = $p->quantity + $item->quantity;
                $p->save();
            }
            InvoicePart::where("invoice_id", $invoice->id)->delete();
            $parts = $request->get('parts');
            foreach ($parts as $item){
                $part = new InvoicePart;
                $part->invoice_id = $invoice->id;
                if(isset($item["part_id"])) $part->part_id = $item['part_id'];
                if(isset($item["name"])) $part->name = $item['name'];
                if(isset($item["part_number"])) $part->part_number = $item['part_number'];
                if(isset($item["description"])) $part->description = $item['description'];
                if(isset($item["quantity"])) $part->quantity = $item['quantity'];
                if(isset($item["extend"])) $part->extend = $item['extend'];
                if(isset($item["price"])) $part->price = $item['price'];
                if(isset($item["warranty"])) $part->warranty = $item['warranty'];
                if($part->save()){
                    $p = Part::where('id', $item['part_id'])->first();
                    $p->quantity = $p->quantity - $item['quantity'];
                    $p->save();
                }
            }
            Repair::where("invoice_id", $invoice->id)->delete();
            $repairs = $request->get('repairs');
            foreach ($repairs as $item){
                $repair = new Repair;
                $repair->invoice_id = $invoice->id;
                if(isset($item['description'])) $repair->description = $item['description'];
                if(isset($item['labor'])) $repair->labor = $item['labor'];
                if(isset($item['time'])) $repair->time = $item['time'];
                $repair->save();
            }
            
            Deposit::where("invoice_id", $invoice->id)->delete();
            $deposits = $request->get('deposits');
            foreach ($deposits as $item){
                $deposit = new Deposit;
                $deposit->invoice_id = $invoice->id;
                if(isset($item['description'])) $deposit->description = $item['description'];
                if(isset($item['amount'])) $deposit->amount = $item['amount'];
                $deposit->save();
            }
            $this->total($invoice->id);
        }
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $data = Invoice::findOrFail($id);
        $data->deleted = 1;
        $data->save();
        //$data->delete();
    }
       
    public function send(Request $request){
        try{
            $invoice = new \App\Mail\Invoice();
            $type=$request->get('type');
            $item = $request->get('item');
            $pdf = $request->get('pdf');
            $pdf_signed = $request->get('pdf_signed');
            $url_images=[];
            
          
        $images= $request->get('images');
       foreach ($images as $image) {
            if($image['select'])
            $url_images[]= url('images/' . $image['AttachmentID']);
         }
        if(!empty($pdf_signed)){
            $url_pdf = url('pdf/' . $pdf_signed);
        }else{
           
            $url_pdf = url('pdf/' . $pdf);
        }
       
     
    
            $invoice = new \App\Mail\Invoice();
            $type=$request->get('type');
            $item = $request->get('item');
            $pdf = $request->get('pdf');
            $phone = $request->get('phone');
            $client = $request->get('client');
            $pdf_signed = $request->get('pdf_signed');
            
            if(!empty($pdf_signed)) $invoice->pdf = $pdf_signed;
            else $invoice->pdf = $pdf;
            
            $invoice->images = $request->get('images');
            if ($type=='email' || $type=='both'){
                 Mail::to($request->get('email'))->send($invoice);
            }
            $message= $client . ", you can download your invoice from Guane Station from here:" . $url_pdf ." . We do not answer this number, if you want to contact us directly call us (786) 253-0646. Thank you very much!! Message from Guane Station." ;
           // var_dump($url_images);
            if ($type=='sms' || $type=='both'){
               $this->sendSms($phone, $message, $url_images);

            }
          
        }
        catch(Exception $ex){
            //return $ex->getMessage();
           // Log::warning('Showing send email error for user: '.$email['to_address'].'. The id in Email table: '.$email['id']);
        }
    }
    
    public function total($id){
        $invoice = Invoice::findOrFail($id);
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $sub_total = Common::getSubTotal($invoice);
        $tax_cal = $sub_total * $tax->value / 100;
        if($invoice->payment_method == "check") $total = $sub_total;
        else $total = round($sub_total + $tax_cal,2);
        $invoice->total = $total;
        $invoice->save();
        return $total;
    }
    public function sendSms($nomber,$message, $url){
        // Your Account SID and Auth Token from twilio.com/console
           $auth_token = env('TWILIO_AUTH_TOKEN');
        $account_sid = env('TWILIO_ACCOUNT_SID');
        $twilio_number = env('TWILIO_NUMBER');
       
         $to_number = $nomber;
         $message = $message;
         $images = $url;
         $mediaUrl= [];
        
        // In production, these should be environment variables. E.g.:
            // $auth_token = $_ENV["TWILIO_AUTH_TOKEN"]

            // A Twilio number you own with SMS capabilities
            
           
           if( isset($images)){
                foreach ($images as $imagen){
            $mediaUrl[]= url($imagen);
           }
           }
          
           //dd($mediaUrl);
           
            try {
                $client = new ClientSms
                ($account_sid, $auth_token);
              
                $client->messages->create(
                    // Where to send a text message (your cell phone?)
                    $to_number,
                    array(
                        'from' => $twilio_number,
                        'body' => $message,
                        'mediaUrl'=>  $mediaUrl,
                        'applicationSid'=> "test sms"
                    )
                );
              
              return "ok";
            } catch (Exception $e) {
                
                return $e->getMessage();
            }
    }
}
