<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Invoice;
use App\Http\Controllers\Api\InvoicesController;

class Alert extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'alert:invoice';
    protected $invController;
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(InvoicesController $invoiceController)
    {
        parent::__construct();
        $this->invController= $invoiceController;

    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $invoices = Invoice::where('status', 'unpaid')
            ->whereRaw("CONVERT_TZ(NOW(), @@session.time_zone, '+00:00') > DATE_ADD(created_at, INTERVAL 15 DAY)")
            ->with(['client'])
            ->get();
           
         $url =[];   
        foreach ($invoices as $invoice) {
            if (isset($invoice->client->phone ) && !empty($invoice->client->phone)){
                 
                 if(!empty(($invoice->pdf_signed))){
                    $url_pdf = url('pdf/' . $invoice->pdf_signed);
                }else{
                   
                    $url_pdf = url('pdf/' . $invoice->pdf);
                }
                $message="Invoice " . $invoice->invoice_number . " unpaid , check detail in this link " .  $url_pdf;
               // $this->invController->sendSms("7866084763",$message, $url);
                $this->invController->sendSms($invoice->client->phone,$message, $url);
                

            }
            
             
        }
          $message1="hola tarru se ha ejecutado el cron de envio de SMS mecanicos, parece todo ok";
         $this->invController->sendSms("7866084763",$message1, $url);

    }
}
