<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Part;

class PartsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $per_page = 25;
        if(!empty($request->get("per_page"))) $per_page =  $request->get("per_page");
        $data = Part::where("parts.deleted", 0)
                ->when($request->get("provider"), function($query) use ($request){
                        return $query->join('providers', 'parts.provider_id', '=', 'providers.id')
                                ->where("providers.name", "like", "%".$request->get("provider")."%");
                    })
                ->when($request->get("description"), function($query) use ($request){
                        return $query->where("parts.description", "like", "%".$request->get("description")."%");
                    })
                ->when($request->get("part_number"), function($query) use ($request){
                        return $query->where("parts.part_number", "like", "%".$request->get("part_number")."%");
                    })
                ->when($request->get("description"), function($query) use ($request){
                        return $query->where("parts.description", "like", "%".$request->get("description")."%");
                    })
                ->when($request->get("extend"), function($query) use ($request){
                        return $query->where("parts.extend", "like", "%".$request->get("extend")."%");
                    })
                ->when($request->get("price"), function($query) use ($request){
                        return $query->where("parts.price", "like", "%".$request->get("price")."%");
                    })
                ->when($request->get("warranty"), function($query) use ($request){
                        return $query->where("parts.warranty", "like", "%".$request->get("warranty")."%");
                    })
                ->with('provider')
                ->select("parts.*")
                ->orderBy('id','DESC')
                ->paginate($per_page);
        return $data;
    }
    
    public function getAll(Request $request){
        $parts = Part::where("parts.deleted", 0)
                ->when($request->get("provider_id"), function($query) use ($request){
                        return $query->where("parts.provider_id", $request->get("provider_id"));
                    })
                ->get();
        return $parts;
    }
    public function getAvailableParts(){
        $parts = Part::with(['provider',])
                ->where("parts.deleted", 0)
                ->where("quantity", ">", 0)
                ->get();
        return $parts;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "provider_id" => 'required',
            //"bill_id" => 'required',
            "quantity" => 'required',
            //"part_number" => 'required',
            //"name" => 'required',
            "description" => 'required',
            "extend" => 'required',
            "price" => 'required',
            //"warranty" => 'required',
        ]);
        Part::create($request->all());
        return;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $parts = Part::with(['provider',])->findOrFail($id);
        return $parts;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "provider_id" => 'required',
            //"bill_id" => 'required',
            "quantity" => 'required',
            //"part_number" => 'required',
            //"name" => 'required',
            "description" => 'required',
            "extend" => 'required',
            "price" => 'required',
            //"warranty" => 'required',
        ]);
        Part::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Part::findOrFail($id);
        $data->deleted = 1;
        $data->save();
        //$data->delete();
    }
}
