<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PDF;
use App\Invoice;
use App\Estimate;
use App\Setting;
use App\Worker;

class AppController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('app');
    }
    public function index1()
    {
        return 'app';
    }
    public function generatePdf($id){
        $invoice = Invoice::with(['client','worker', 'vehicle', "bills", 'parts', 'repairs'])->findOrFail($id);
        $list = Setting::get();
        $settings = [];
        foreach ($list as $item) {
            $settings[$item->key] = $item->value;
        }
        $billsDetail = [];
        $manager = Worker::where("is_main", 'y')->first();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $amount = 0;
        foreach ($invoice->bills as $bill) {
            foreach ($bill->bill_details as $detail) {
                $amount += $detail->quantity * $detail->price;
                $billsDetail[] = $detail;
            }
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        $cant_p = $amount;
        $cant_r = 0;
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
            $cant_r += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        $taxc = 0;
        if($invoice->payment_method != 'check') {
            $taxc = round(($amount * $tax->value / 100),2);
            $total = round($amount + ($amount * $tax->value / 100),2);
        }
        else {
            $total = round($amount,2);
        }
        
	$data = [
            'invoice' => $invoice,
            'settings' => $settings,
            'billsDetail' => $billsDetail,
            'tax' => $taxc,
            'parts' => round($cant_p,2),
            'repairs' => round($cant_r,2),
            'sub_total' => $amount,
            'total' => $total,
            'manager_signature' => $manager->signature,
            'img'=> '',
            
	];
	$pdf = PDF::loadView('pdf', $data);
        $time = time();
	$pdf->setPaper('a4')->setOrientation('landscape')->setOption('margin-bottom', 0)->save('pdf/'.str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'.pdf');
        $invoice->pdf = str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'.pdf';
        $invoice->save();
        return $invoice;
        //return view('pdf', $data);
    }
    public function generatePdfEstimate($id){
        $invoice = Estimate::with(['client','worker', 'vehicle', "eparts", 'parts', 'repairs'])->findOrFail($id);
        $list = Setting::get();
        $settings = [];
        foreach ($list as $item) {
            $settings[$item->key] = $item->value;
        }
        $manager = Worker::where("is_main", 'y')->first();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $amount = 0;
        foreach ($invoice->eparts as $part){
            $amount += $part->quantity * $part->price;
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        $cant_p = $amount;
        $cant_r = 0;
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
            $cant_r += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        $taxc = 0;
        if($invoice->payment_method != 'check') {
            $taxc = round(($amount * $tax->value / 100),2);
            $total = round($amount + ($amount * $tax->value / 100),2);
        }
        else {
            $total = round($amount,2);
        }
        
	$data = [
            'invoice' => $invoice,
            'settings' => $settings,
            'tax' => $taxc,
            'parts' => round($cant_p,2),
            'repairs' => round($cant_r,2),
            'sub_total' => $amount,
            'total' => $total,
            'manager_signature' => $manager->signature,
            'img'=> '',
            
	];
	$pdf = PDF::loadView('pdf-estimate', $data);
        $time = time();
	$pdf->setPaper('a4')->setOrientation('landscape')->setOption('margin-bottom', 0)->save('pdf/'.str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'.pdf');
        $invoice->pdf = str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'.pdf';
        $invoice->save();
        return $invoice;
        //return view('pdf', $data);
    }
    public function singPdf(Request $request){
        $id = $request->get("id");
        $img = $request->get('img');
        $invoice = Invoice::with(['client','worker', 'vehicle', "bills", 'parts', 'repairs'])->findOrFail($id);
        $list = Setting::get();
        $settings = [];
        foreach ($list as $item) {
            $settings[$item->key] = $item->value;
        }
        $billsDetail = [];
        $manager = Worker::where("is_main", 'y')->first();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $amount = 0;
        foreach ($invoice->bills as $bill) {
            foreach ($bill->bill_details as $detail) {
                $amount += $detail->quantity * $detail->price;
                $billsDetail[] = $detail;
            }
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        $cant_p = $amount;
        $cant_r = 0;
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
            $cant_r += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        $taxc = 0;
        if($invoice->payment_method != 'check') {
            $taxc = round(($amount * $tax->value / 100),2);
            $total = round($amount + ($amount * $tax->value / 100),2);
        }
        else {
            $total = round($amount,2);
        }
        
	$data = [
            'invoice' => $invoice,
            'settings' => $settings,
            'billsDetail' => $billsDetail,
            'tax' => $taxc,
            'parts' => round($cant_p,2),
            'repairs' => round($cant_r,2),
            'sub_total' => $amount,
            'total' => $total,
            'manager_signature' => $manager->signature,
            'img'=> $img,
            
	];
	$pdf = PDF::loadView('pdf', $data);
        $time = time();
	$pdf->setPaper('a4')->setOrientation('landscape')->setOption('margin-bottom', 0)->save('pdf/'.str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'-signed.pdf');
        $invoice->pdf_signed = str_slug($invoice->client->name)."-".$invoice->repair_type."-".$invoice->invoice_number.'-'.date('d-m-Y').'('.$time.')'.'-signed.pdf';
        $invoice->save();
        return $invoice;
        //return view('pdf', $data);
    }
    public function generatePdfv($id){
        $invoice = Invoice::with(['client','worker', 'vehicle', "bills", 'parts', 'repairs'])->findOrFail($id);
        $list = Setting::get();
        $settings = [];
        foreach ($list as $item) {
            $settings[$item->key] = $item->value;
        }
        $billsDetail = [];
        $manager = Worker::where("is_main", 'y')->first();
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $amount = 0;
        foreach ($invoice->bills as $bill) {
            foreach ($bill->bill_details as $detail) {
                $amount += $detail->quantity * $detail->price;
                $billsDetail[] = $detail;
            }
        }
        foreach ($invoice->parts as $part){
            $amount += $part->quantity * $part->price;
        }
        $cant_p = $amount;
        $cant_r = 0;
        foreach ($invoice->repairs as $repair){
            $amount += $repair->labor * $repair->time;
            $cant_r += $repair->labor * $repair->time;
        }
        $amount += $invoice->sublet_other;
        $amount += $invoice->shop_supplies;
        $amount += $invoice->fees;
        $taxc = 0;
        if($invoice->payment_method != 'check') {
            $taxc = round(($amount * $tax->value / 100),2);
            $total = round($amount + ($amount * $tax->value / 100),2);
        }
        else {
            $total = round($amount,2);
        }
        
	$data = [
            'invoice' => $invoice,
            'settings' => $settings,
            'billsDetail' => $billsDetail,
            'tax' => $taxc,
            'parts' => round($cant_p,2),
            'repairs' => round($cant_r,2),
            'sub_total' => $amount,
            'total' => $total,
            'manager_signature' => $manager->signature,
            'img'=> '',
            
	];
	//$pdf = PDF::loadView('pdf', $data);
//	$pdf->stream($invoice->invoice_number.'.pdf');
        return view('pdf', $data);
    }
}
