<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->increments('id');
            $table->smallInteger('year');
            $table->tinyInteger('month');
            $table->timestamp('date');
            $table->timestamp('inv_date')->nullable();
            $table->double('rent_val',10,2)->default(0);
            $table->double('workers_salary',10,2)->default(0);
            $table->double('debit_credit',10,2)->default(0);
            $table->double('dc_remaining',10,2)->default(0);
            $table->bigInteger('limit_invoice')->default(0);
            $table->double('excedent',10,2)->default(0);
            $table->double('cash_paid',10,2)->default(0);
            $table->double('pending_debt',10,2)->default(0);
            $table->double('debt_was',10,2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
