<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Libraries\Common;
use App\Invoice;
use App\Worker;
use App\Setting;
use App\Http\Controllers\Controller;

class StadisticsController extends Controller
{
    public function getCurrentMonth(Request $request) {
        $month = explode("/", $request->get('month'));
        $month = $month[1]."-".$month[0];
        
        $start_date = date('m',strtotime($month)).'/01/'.date('Y',strtotime($month));
        $end_date = date('m',strtotime($month))."/".date('t',strtotime($start_date))."/".date('Y',strtotime($month)); 
        
        $data= [
            'balance' => 0,
            'sub' => 0,
            'tax' => 0,
            'transaction_fee' => 0,
        ];
        
        $invoices  = Invoice::where('repair_type', 'invoice')
                ->when($start_date, function($query) use ($start_date){
                        return $query->where("pay_date", ">", date('Y-m-d H:i:s', strtotime($start_date)));
                    })
                ->when($end_date, function($query) use ($end_date){
                        return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")));
                    })
                ->get();
                    
        $tax = Setting::where("key", 'tax')->firstOrFail();
        $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
        $balance = [
            'balance' => 0,
            'sub' => 0,
            'transaction_fee' => 0,
            'tax' => 0
        ];
        
        foreach ($invoices as $invoice) {
            $invoice_n = Common::getInvoiceNumbers($invoice);
            switch ($invoice->payment_method){
                case 'cash':
                    $sub = $invoice_n['sub_total'];
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $balance['balance'] += round($sub + $tax_cal,2);
                    $balance['sub'] += round($sub,2);
                    $balance['tax'] += $tax_cal;
                    break;
                case 'check':
                    $sub = $invoice_n['sub_total'];
                    $balance['balance'] += $sub;
                    $balance['sub'] += $sub;
                    break;
                case 'debit':
                    $sub = $invoice_n['sub_total'];
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $balance['balance'] += round($sub + $tax_cal,2);
                    $balance['sub'] += round($sub - $tf,2);
                    $balance['tax'] += $tax_cal;
                    $balance['transaction_fee'] += $tf;
                    break;
                case 'credit':
                    $sub = $invoice_n['sub_total'];
                    $tax_cal = round($sub * $tax->value / 100,2);
                    $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                    $balance['balance'] += round($sub + $tax_cal,2);
                    $balance['sub'] += round($sub - $tf,2);
                    $balance['tax'] += $tax_cal;
                    $balance['transaction_fee'] += $tf;
                    break;
            }
        }
        
        $total_parts = Common::getPartPartsExpenses($start_date, $end_date);
        
        $expenses = 0;

        $rent = Setting::where("key", 'rent')->firstOrFail();
        $expenses += $rent->value;

        $cant_s = Common::cantS(date("Y-m", strtotime($start_date)));
        $sum_workers_tax = 0; 
        $workers = Worker::where("pay_tax",1)->get();
        foreach ($workers as $worker){
            $sum_workers_tax += $worker->tax * $cant_s;
        }
        $sum_workers_tax = round($sum_workers_tax,2);

        $expenses += $sum_workers_tax;

        $workers = Worker::where("is_main", '!=', 'y')->get();
        $salary = 0;
        foreach ($workers as $worker) {
            $salary += Common::getWorkerSalary($worker, $start_date, $end_date);
        }
        $salary = round($salary, 2);

        $expenses += $salary;

        $expenses += $total_parts['total_p'] + $total_parts['total_op'];

        $incomes = $balance['sub'] - $expenses;

        $data['balance'] += $balance['balance'];
        $data['sub'] += $balance['sub'];
        $data['tax'] += $balance['tax'];
        $data['transaction_fee'] += $balance['transaction_fee'];
        
        $data['expenses'] = $expenses;
        $data['incomes'] = $incomes;
        
        return $data;
    }
    public function getMonths(Request $request){
        $year = date("Y");
        $year = $request->get("year");
        
        $data ['stadistics'] = [
            "Jan." => [
                "date" => "Jan.",
                "month_number" => "01"
            ],
            "Feb." => [
                "date" => "Feb.",
                "month_number" => "02"
            ],
            "Mar." => [
                "date" => "Mar.",
                "month_number" => "03"
            ],
            "Apr." => [
                "date" => "Apr.",
                "month_number" => "04"
            ],
            "May." => [
                "date" => "May.",
                "month_number" => "05"
            ],
            "Jun." => [
                "date" => "Jun.",
                "month_number" => "06"
            ],
            "Jul." => [
                "date" => "Jul.",
                "month_number" => "07"
            ],
            "Aug." => [
                "date" => "Aug.",
                "month_number" => "08"
            ],
            "Sep." => [
                "date" => "Sep.",
                "month_number" => "09"
            ],
            "Oct." => [
                "date" => "Oct.",
                "month_number" => "10"
            ],
            "Nov." => [
                "date" => "Nov.",
                "month_number" => "11"
            ],
            "Dec." => [
                "date" => "Dec.",
                "month_number" => "12"
            ],
        ];
        $temp = $data['stadistics'];
         $data['stadistics'] = [];
         $total = [
             'balance' => 0,
             'expenses' => 0,
             'incomes' => 0,
         ];
         $c_month = date("m");
         $c_year = date("Y");
        foreach ($temp as $item) {
            
            if($year < $c_year || ( $year == $c_year && $item["month_number"] <= $c_month)) {
                
                $start_date = $year."-".$item["month_number"]."-01";
                $end_date = $year."-".$item["month_number"]."-".date('t',strtotime($start_date)); 

                $invoices  = Invoice::where('repair_type', 'invoice')
                               ->when($start_date, function($query) use ($start_date){
                                       return $query->where("pay_date", ">", date('Y-m-d H:i:s', strtotime($start_date)));
                                   })
                               ->when($end_date, function($query) use ($end_date){
                                       return $query->where("pay_date", "<=", date('Y-m-d H:i:s', strtotime($end_date." 23:59:59")));
                                   })
                               ->get();

                       $tax = Setting::where("key", 'tax')->firstOrFail();
                       $trnsaction_fee = Setting::where("key", 'transaction_fee')->firstOrFail();
                       $balance = [
                           'balance' => 0,
                           'sub' => 0,
                           'transaction_fee' => 0,
                           'tax' => 0
                       ];

                       foreach ($invoices as $invoice) {
                           $invoice_n = Common::getInvoiceNumbers($invoice);
                           switch ($invoice->payment_method){
                               case 'cash':
                                   $sub = $invoice_n['sub_total'];
                                   $tax_cal = round($sub * $tax->value / 100,2);
                                   $balance['balance'] += round($sub + $tax_cal,2);
                                   $balance['sub'] += round($sub,2);
                                   $balance['tax'] += $tax_cal;
                                   break;
                               case 'check':
                                   $sub = $invoice_n['sub_total'];
                                   $balance['balance'] += $sub;
                                   $balance['sub'] += $sub;
                                   break;
                               case 'debit':
                                   $sub = $invoice_n['sub_total'];
                                   $tax_cal = round($sub * $tax->value / 100,2);
                                   $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                                   $balance['balance'] += round($sub + $tax_cal,2);
                                   $balance['sub'] += round($sub - $tf,2);
                                   $balance['tax'] += $tax_cal;
                                   $balance['transaction_fee'] += $tf;
                                   break;
                               case 'credit':
                                   $sub = $invoice_n['sub_total'];
                                   $tax_cal = round($sub * $tax->value / 100,2);
                                   $tf = round(($sub + $tax_cal) * $trnsaction_fee->value / 100,2);
                                   $balance['balance'] += round($sub + $tax_cal,2);
                                   $balance['sub'] += round($sub - $tf,2);
                                   $balance['tax'] += $tax_cal;
                                   $balance['transaction_fee'] += $tf;
                                   break;
                           }
                       }
                $total_balance = $balance['balance'];
                
                $total_parts = Common::getPartPartsExpenses($start_date, $end_date);

                $expenses = 0;

                $rent = Setting::where("key", 'rent')->firstOrFail();
                $expenses += $rent->value;

                $cant_s = Common::cantS(date("Y-m", strtotime($start_date)));
                $sum_workers_tax = 0; 
                $workers = Worker::where("pay_tax", 1)->get();
                foreach ($workers as $worker){
                    $sum_workers_tax += $worker->tax * $cant_s;
                }
                $sum_workers_tax = round($sum_workers_tax,2);

                $expenses += $sum_workers_tax;

                $workers = Worker::where("is_main", '!=', 'y')->get();
                $salary = 0;
                foreach ($workers as $worker) {
                    $salary += Common::getWorkerSalary($worker, $start_date, $end_date);
                }
                $salary = round($salary, 2);

                $expenses += $salary;

                $expenses += $total_parts['total_p'] + $total_parts['total_op'];

                $incomes = $balance['sub'] - $expenses;

                $item['balance'] = round($total_balance,2);
                $item['expenses'] = round($expenses,2);
                $item['incomes'] = round($incomes,2);
            }
            else {
                $item['balance'] = 0;
                $item['expenses'] = 0;
                $item['incomes'] = 0;
            }
            
            $data ['stadistics'][] = $item;
            
            $total['balance'] += $item['balance'];
            $total['expenses'] += $item['expenses'];
            $total['incomes'] += $item['incomes'];
        }
        $data['totals'] = $total;
        return $data;
    }
}
