<?php

namespace App;

use App\Scopes\InvoiceScope;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $fillable = [
        'bill_id_old','form_date',
        'client_ab','written_estimate','written_amount',
        'cancel_fee','storage_fee','diagnostic_type',
        'diagnostic_amount','charges_type','charges_amount',
        'sublet_other','shop_supplies','fees',
        'save_old_parts','complaint_problem','warranty_type',
        'warranty_amount','miles_in','miles_out',
        'payment_method','repair_type','client_id',
        'vehicle_id','worker_id','prov',
        'part_invoice','pdf_date','pdf_time','status',
        ];
    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope(new InvoiceScope);
    }
    public function invoice_bill()
    {
        return $this->hasMany(InvoiceBill::class);
    }
    public function bills()
    {
        return $this->belongsToMany(Bill::class, "invoice_bills", "invoice_id", "bill_id");
    }
    public function parts()
    {
        return $this->hasMany(InvoicePart::class);
    }
    public function repairs()
    {
        return $this->hasMany(Repair::class);
    }
    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }
    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
    public function worker()
    {
        return $this->belongsTo(Worker::class);
    }
}
