<?php
use App\Libraries\Common;
?>
<!DOCTYPE html>
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="{{ app()->getLocale() }}">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="{{ config('app.name', 'Laravel') }}" name="description" />
    <meta content="" name="author" />
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <!--<link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />-->
    <link href="{{ asset('assets/global/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet"
        type="text/css" />
    <link href="{{ asset('css/app.css') }}" rel="stylesheet" type="text/css" />
    <!-- END HEAD -->

<body class="pdf">
    <table class="">
        <tbody>
            <tr>
                <td colspan="5" rowspan="10" class="pdftd pcuston">
                    <p style=""><b class="bcollor"> PLEASE READ CAREFULLY, CHECK ONE OF THE STATEMENTS BELOW, AND
                            SIGN: </b></p>
                    <p style="">I UNDERSTAND THAT, UNDER STATE LAW, I AM ENTITLED TO A WRITTEN ESTIMATE IF MY
                        FINAL BILL WILL EXCEED $150.</p><br />
                    <p style="margin: 0 !important"><span
                            class="underlineb">{{ $invoice->written_estimate == 'n' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;' }}</span>I
                        DO NOT REQUEST A WRITTEN ESTIMATE.</p>
                    <p style="margin: 0 !important"><span
                            class="underlineb">{{ $invoice->written_estimate == 'exceed' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;' }}</span>
                        I DO NOT REQUEST A WRITTEN ESTIMATE AS LONG AS THE REPAIR COSTS DO NOT EXCEED <span
                            class="underlineb">${{ $invoice->written_amount ? $invoice->written_amount : '0.00' }}</span>.
                        THE SHOP MAY NOT EXCEED THIS AMOUNT WITHOUT MY WRITTEN OR ORAL APPROVAL.</p>
                    <p style="margin: 0 !important"><span
                            class="underlineb">{{ $invoice->written_estimate == 'y' ? 'X' : '&nbsp;&nbsp;&nbsp;&nbsp;' }}</span>I
                        REQUEST A WRITTEN ESTIMATE.</p>


                    <table>
                        <tr>
                            <td style="vertical-align: bottom; text-align: center">
                                <p style="">SIGNED:</p>
                            </td>
                            <td style="vertical-align: bottom; text-align: center">
                                <br /><br />
                                <p>&nbsp;&nbsp;____________________&nbsp;&nbsp;</p>
                            </td>
                            <td style="vertical-align: bottom; text-align: center">
                                <p style="">DATE: {{ date('m/d/Y') }}</p>
                            </td>
                        </tr>
                    </table>
                </td>
                <td colspan="6" rowspan="4" class="pdftd text-center pcuston">
                    <p style="font-size: 20px"><b class="bcollor">{{ $settings['company_name'] }}</b></p>
                    <p style="font-size: 16px">{{ $settings['company_adress'] }}</p>
                    <p style="font-size: 16px">
                        <b class="bcollor">MVR: {{ $settings['mvr'] }}</b> &nbsp;&nbsp;&nbsp;
                        {{ $settings['company_phone'] }}
                    </p>
                    <p style="font-size: 16px">
                        <b class="bcollor">
                            FLORIDA REGISTRATION: {{ $settings['licence'] }}
                        </b>
                    </p>
                    <p style="font-size: 16px">
                        <b class="bcollor">
                            ESTIMATE: {{ $invoice->invoice_number }}
                        </b>
                    </p>
                </td>
                <td colspan="5" class="pdftd text-center">
                    <?php if($invoice->warranty_type == 'month') :?><p style="" class="pmore"> <span
                            class="underlineb">{{ $invoice->warranty_amount }}</span> month/mile warranty on all parts.
                    </p><?php endif;?>
                    <?php if($invoice->warranty_type == 'mile') :?><p style="" class="pmore"> month/ <span
                            class="underlineb">{{ $invoice->warranty_amount }}</span> mile warranty on all parts.</p>
                    <?php endif;?>
                </td>
            </tr>
            <tr class="text-center">
                <td colspan="5" class="text-center ftmed pdftd">
                    <p style="" class="pmore"> Intended Payment Method:</p>
                </td>
            </tr>
            <tr class="text-center">
                <td id="pay_cell" colspan="5" class="text-center pdftd">
                    <p style="" class="pmore">{{ $invoice->payment_method }}</p>
                </td>
            </tr>
            <tr class="">
                <td colspan="5" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Date: </b> {{ $invoice->pdf_date }}&nbsp;&nbsp;
                        <b class="bcollor">Time:</b> {{ $invoice->pdf_time }}
                    </p>
                </td>
            </tr>
            <tr>
                <td colspan="6" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Name:</b> {{ $invoice->client->name }}</p>
                </td>
                <td colspan="5" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Proposed Completion Date:</b></p>
                </td>
            </tr>
            <tr>
                <td colspan="6" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Address:</b> {{ $invoice->client->address }}
                    </p>
                </td>
                <td colspan="5" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Home Ph:</b> {{ $invoice->client->home_ph }}
                    </p>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">City:</b> {{ $invoice->client->city }}</p>
                </td>
                <td colspan="1" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">State:</b> {{ $invoice->client->state }}</p>
                </td>
                <td colspan="3" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Zip:</b> {{ $invoice->client->zip }}</p>
                </td>
                <td colspan="5" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Work Ph:</b> {{ $invoice->client->work_ph }}
                    </p>
                </td>
            </tr>
            <tr>
                <td colspan="6" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Other Authorized Person:</b>
                        {{ $invoice->client->person }}</p>
                </td>
                <td colspan="5" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Phone:</b> {{ $invoice->client->phone }}</p>
                </td>
            </tr>
            <tr>
                <td colspan="2" class="pdftd">
                    <p style=""class="pmore"><b class="bcollor">Year/Make:</b>
                        {{ $invoice->vehicle->year_make }}</p>
                </td>
                <td colspan="4" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Model:</b> {{ $invoice->vehicle->model }}
                    </p>
                </td>
                <td colspan="2" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Tag:</b> {{ $invoice->client->tag }}</p>
                </td>
                <td colspan="3" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Miles In:</b> {{ $invoice->miles_in }}</p>
                </td>
            </tr>
            <tr>
                <td colspan="8" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">VIN#:</b> {{ $invoice->vehicle->number }}
                    </p>
                </td>
                <td colspan="3" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Miles Out:</b> {{ $invoice->miles_out }}</p>
                </td>
            </tr>
            <tr>
                <td colspan="5" class="center ftsmall pdftd">
                    <p style="" class="pmore"> *U/Used&nbsp;R:Rebuilt&nbsp;RC/Reconditioned&nbsp;NC/No
                        Chg/Warranty&nbsp;RD/Reduced/ </p>
                </td>
                <td colspan="11" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Save Old Parts:</b>
                        {{ $invoice->save_old_parts }} (Core may apply) </p>
                </td>
            </tr>
            <tr>
                <td class="col_qty pdftd" style="width: 3%">
                    <p style="" class="pmore1"><b class="bcollor">Qty</b></p>
                </td>
                <td class="col_part pdftd" style="width: 4%">
                    <p style="" class="pmore1"><b class="bcollor">Part</b></p>
                </td>
                <td class="col_dsc pdftd" style="width: 28%">
                    <p style="" class="pmore1"><b class="bcollor">Description</b></p>
                </td>
                <td class="col_prc pdftd" style="width: 5%">
                    <p style="" class="pmore1"><b class="bcollor">Price</b></p>
                </td>
                <td class="col_prc pdftd" style="width: 5%">
                    <p style="" class="pmore1"><b class="bcollor">Warranty</b></p>
                </td>
                <td colspan="3" rowspan="2" class="pdftd"<p style="" class="pmore1"><b
                        class="bcollor">Complaint/Problem:</b></p>
                </td>
                <td colspan="8" rowspan="2" class="pdftd">
                    <p style="" class="pmore1">{{ $invoice->complaint_problem }}</p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 0); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 1); ?>
                <td class="pdftd" colspan="3" rowspan="2">
                    <p style="" class="pmore">
                        <b class="bcollor">Labor charges based on:</b><br>
                        {{ $invoice->charges_type }} rate
                    </p>
                </td>
                <td class="pdftd" colspan="8" rowspan="2">
                    <p style="" class="pmore">
                        <b class="bcollor">Estimate/diagnostic fee:</b><br>
                        <label id="lb_hourly_at"><?php if($invoice->diagnostic_type == "hourly_at"):?><span class="underlineb">$
                                <?php echo number_format($invoice->diagnostic_amount, 2); ?></span><?php endif;?></label> / Or hourly at &nbsp;
                        <label id="lb_per_hour"><?php if($invoice->diagnostic_type == "per_hour"):?><span class="underlineb">$
                                <?php echo number_format($invoice->diagnostic_amount, 2); ?></span><?php endif;?></label> Per hour
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 2); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 3); ?>
                <td colspan="11" class="pdftd">
                    <p style="font-size: 12px;" class="pmore">A storage fee of $ <span
                            class="underlineb">{{ $invoice->storage_fee }}</span> per day may be applied to vehicles
                        which are not claimed within 3 working days </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 4); ?>
                <td colspan="6" class="pdftd">
                    <p style="" class="pmore"><b class="bcollor">Description of Repairs (invoice)</b></p>
                </td>
                <td class="pdftd">
                    <p style="" class="pmore1"><b class="bcollor">Labor</b></p>
                </td>
                <td class="pdftd">
                    <p style="" class="pmore1"><b class="bcollor">Time</b></p>
                </td>
                <td colspan="3" class="pdftd" class="pmore1">
                    <p style=""><b class="bcollor">Charges</b></p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 5); ?>
                <?php echo Common::repairRow($invoice->repairs, 0); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="" class="pmore">
                        <b class="bcollor">PARTS:</b>
                    </p>
                    <p class="bcollor" style="" class="pmore">
                        $ {{ number_format($parts, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 6); ?>
                <?php echo Common::repairRow($invoice->repairs, 1); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 7); ?>
                <?php echo Common::repairRow($invoice->repairs, 2); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="" class="pmore">
                        <b class="bcollor">LABOR:</b>
                    </p>
                    <p class="bcollor" style="" class="pmore">
                        $ {{ number_format($repairs, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 8); ?>
                <?php echo Common::repairRow($invoice->repairs, 3); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 9); ?>
                <?php echo Common::repairRow($invoice->repairs, 4); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="" class="pmore">
                        <b class="bcollor">SUBLET/OTHER:</b>
                    </p>
                    <p class="bcollor" style="" class="pmore">
                        $ {{ number_format($invoice->sublet_other, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 10); ?>
                <?php echo Common::repairRow($invoice->repairs, 5); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 11); ?>
                <?php echo Common::repairRow($invoice->repairs, 6); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="font-size: 16px;" class="pmore">
                        <b class="bcollor">SUPPLIES:</b>
                    </p>
                    <p class="bcollor" style="font-size: 16px;" class="pmore">
                        $ {{ number_format($invoice->shop_supplies, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 12); ?>
                <?php echo Common::repairRow($invoice->repairs, 7); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 13); ?>
                <?php echo Common::repairRow($invoice->repairs, 8); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="font-size: 16px;" class="pmore">
                        <b class="bcollor">FEES:</b>
                    </p>
                    <p class="bcollor" style="font-size: 16px;" class="pmore">
                        $ {{ number_format($invoice->fees, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 14); ?>
                <?php echo Common::repairRow($invoice->repairs, 9); ?>
            </tr>
            <tr>
                <?php echo Common::billRowEstimate($invoice->eparts, $invoice->parts, 15); ?>
                <?php echo Common::repairRow($invoice->repairs, 10); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="font-size: 16px;" class="pmore">
                        <b class="bcollor">SUB-TOTAL:</b>
                    </p>
                    <p class="bcollor" style="font-size: 16px;" class="pmore">
                        $ {{ number_format($sub_total, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <td colspan="5" rowspan="4" class="pdftd">
                    <br />
                    <p style="font-size: 12px">
                        Estimate good for 30 days. Not responsible for damage caused by theft, fire or acts of nature. I
                        hereby authorize the above repairs, including sublet work, along with the necessary materials.
                        You and your employees may operate my vehicle for the purpose of testing, inspection and
                        delivery at my risk. If I cancel repairs prior to their completion for any reason, a tear down
                        and reassembly fee of <span class="underlineb">$ {{ $invoice->cancel_fee }}</span> will be
                        applied.
                    </p>
                    <p style="display: inline-block;vertical-align: bottom;margin: 0 !important;padding: 0 !important">
                        SIGNED:</p>
                    <div
                        style="display: inline-block;vertical-align: bottom;margin: 0 !important;padding: 0 !important; text-align: center">

                        <br /><br />
                        <p style="margin: 0 !important;padding: 0 !important">
                            &nbsp;&nbsp;____________________&nbsp;&nbsp;</p>
                    </div>

                    <p style="display: inline-block;vertical-align: bottom">DATE: {{ date('m/d/Y') }}</p>
                    <br />
                </td>
                <?php echo Common::repairRow($invoice->repairs, 11); ?>
            </tr>
            <tr>

                <?php echo Common::repairRow($invoice->repairs, 12); ?>
                <td class="dh pdftd" colspan="3" rowspan="2">
                    <p style="font-size: 16px;" class="pmore">
                        <b class="bcollor">TAX:</b>
                    </p>
                    <p class="bcollor" style="font-size: 16px;" class="pmore">
                        $ {{ number_format($tax, 2) }}
                    </p>
                </td>
            </tr>
            <tr>
                <?php echo Common::repairRow($invoice->repairs, 13); ?>
            </tr>
            <tr>
                <td colspan="8" class="pdftd">
                    <p style="font-size: 12">**This charge represents costs and profits to the motor vehicle repair
                        facility for miscellaneus shop supplies or waste disposal. ***FS403.718 mandates a $1.00 fee for
                        each new tire sold in the Sate of Florida. ***FS403.7185 mandates a $1.50 fee for each new or
                        remanufactured battery sold in the State of Florida.</p>
                </td>
                <td class="dh pdftd" colspan="3">
                    <p style="font-size: 16px;">
                        <b class="bcollor">TOTAL:</b>
                    </p>
                    <p class="bcollor" style="font-size: 16px;">
                        $ {{ number_format($total, 2) }}
                    </p>
                </td>
            </tr>
        </tbody>
    </table>
</body>

</html>
